PROGRAM test_maxval
!
!  Purpose:
!    To test the generic subroutine maxval with five different types
!    of input data sets.
!
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    01/03/96    S. J. Chapman        Original code
!
USE generic_maxval
IMPLICIT NONE

! List of variables:
INTEGER, DIMENSION(6) :: array_i            ! Integer array
REAL(KIND=sgl), DIMENSION(6) :: array_r     ! Sng prec real arr
REAL(KIND=dbl), DIMENSION(6) :: array_d     ! Dbl prec real arr
COMPLEX(KIND=sgl), DIMENSION(6) :: array_c  ! Sing. prec. cx arr
COMPLEX(KIND=dbl), DIMENSION(6) :: array_dc ! Sing. prec. cx arr
INTEGER :: value_max_i                      ! Max value
REAL(KIND=sgl) :: value_max_r               ! Max value
REAL(KIND=dbl) :: value_max_d               ! Max value
INTEGER :: pos_maxval                       ! Pos of max value

! Initialize arrays
array_i  = (/ -13,  3,  2,  0,  25,  -2  /)
array_r  = (/ -13., 3., 2., 0., 25., -2. /)
array_d  = (/ -13._dbl, 3._dbl, 2._dbl, 0._dbl, 25._dbl, -2._dbl /)
array_c  = (/ (1.,2.), (-4.,-6.), (4.,-7), (3.,4.), &
              (0.,1.), (6.,-8.) /)
array_dc = (/ (1._dbl,2._dbl), (-4._dbl,-6._dbl), &
              (4._dbl,-7._dbl), (3._dbl,4._dbl), &
              (0._dbl,1._dbl), (6._dbl,-8._dbl) /)

! Test integer subroutine.  Include optional argument.
CALL maxval ( array_i, 6, value_max_i, pos_maxval )
WRITE (*,1000) value_max_i, pos_maxval
1000 FORMAT (' Integer args: max value = ',I3, &
             ';  position = ', I3 )

! Test sgl prec real subroutine.  Leave out optional arg.
CALL maxval ( array_r, 6, value_max_r )
WRITE (*,1010) value_max_r
1010 FORMAT (' Single prec real args: max value = ',F7.3)

! Test dbl prec real subroutine.  Use keywords.
CALL maxval ( ARRAY=array_d, NVALS=6, VALUE_MAX=value_max_d )
WRITE (*,1020) value_max_d
1020 FORMAT (' Double prec real args: max value = ',F7.3)

! Test sgl prec cmplx subroutine.  Use scrambled keywords.
CALL maxval ( NVALS=6, ARRAY=array_c, VALUE_MAX=value_max_r, &
              POS_MAXVAL=pos_maxval )
WRITE (*,1030) value_max_r, pos_maxval
1030 FORMAT (' Single precision complex args:' &
             ' max abs value = ',F7.3, &
             ';  position = ', I3 )

! Test dbl prec cmplx subroutine.  Leave out optional arg.
CALL maxval ( array_dc, 6, value_max_d )
WRITE (*,1040) value_max_r
1040 FORMAT (' Double precision complex args:' &
             ' max abs value = ',F7.3 )
 
END PROGRAM
