FUNCTION sinc ( x )
!
!  Purpose:
!    To calculate the sinc function
!       sinc(x) = sin(x) / x
!
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    10/22/95    S. J. Chapman        Original code
!
IMPLICIT NONE

! List of calling arguments:
REAL, INTENT(IN) :: x        ! Value for which to evaluate sinc
REAL :: sinc                 ! Output value sinc(x)

! List of local parameters:
REAL, PARAMETER :: epsilon = 1.0E-30  ! the smallest value for which 
                                      ! to calculate SIN(x)/x
! Check to see of ABS(x) > epsilon.
IF ( ABS(x) > epsilon ) THEN
   sinc = SIN(x) / x
ELSE
   sinc = 1.
END IF

END FUNCTION sinc
