MODULE ran001
!
!  Purpose:
!    To declare data shared between subs random0 and seed.
!
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    10/17/95    S. J. Chapman        Original code
!
IMPLICIT NONE
INTEGER, SAVE :: n = 9876
END MODULE ran001

SUBROUTINE random0 ( ran )
!
!  Purpose:
!    Subroutine to generate a pseudorandom number with a uniform 
!    distribution in the range 0. <= ran < 1.0.
!
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    10/17/95    S. J. Chapman        Original code
!

USE ran001                     ! Shared seed
IMPLICIT NONE

! List of calling arguments:
REAL, INTENT(OUT) :: ran       ! Random number

n = MOD (8121 * n + 28411, 134456 )  ! Next number
ran = REAL(n) / 134456.              ! ran
 
END SUBROUTINE random0

SUBROUTINE seed ( iseed )
!
!  Purpose:
!    To set the seed for random number generator random0.
!
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    10/17/95    S. J. Chapman        Original code
!
USE ran001                     ! Shared seed
IMPLICIT NONE

! List of calling arguments:
INTEGER, INTENT(IN) :: iseed   ! Value to initialize sequence

n = ABS ( iseed )                    ! Set seed.
 
END SUBROUTINE seed
