SUBROUTINE calc_hypotenuse ( side_1, side_2, hypotenuse )
!
!  Purpose:
!    To calculate the hypotenuse of a right triangle from the two 
!    other sides.
!
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    08/27/95    S. J. Chapman        Original code
!
IMPLICIT NONE

! Declare calling parameters:
REAL, INTENT(IN) :: side_1        ! Length of side 1.
REAL, INTENT(IN) :: side_2        ! Length of side 2.
REAL, INTENT(OUT) :: hypotenuse   ! Length of hypotenuse

! Declare local variables:
REAL :: temp                      ! Temporary variable

! Calculate hypotenuse
temp = side_1**2 + side_2**2
hypotenuse = SQRT ( temp )

END SUBROUTINE
