PROGRAM interpolate
!
!  Purpose:
!    To interpolate the value y0 at position x0, given a set of 
!    (x,y) measurements organized in increasing order of x.
!        
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    03/04/96    S. J. Chapman        Original code
!
USE booklib                      ! Use the library
IMPLICIT NONE

! List of parameters:
INTEGER, PARAMETER :: max_size = 1000

! List of variables:
INTEGER :: error                 ! Error flag: 0=no error.
LOGICAL :: exceed = .FALSE.      ! Logical indicating that array 
                                 ! limits are exceeded.
CHARACTER(len=20) :: filename    ! Input data file name
INTEGER :: nvals = 0             ! Number of data values to sort
INTEGER :: status                ! I/O status: 0 for success
REAL :: temp1, temp2             ! Temp variables for reading (x,y)
REAL, DIMENSION(max_size) :: x   ! Values of independent var x.
REAL :: x0                       ! Pos at which to interpolate y0.
REAL, DIMENSION(max_size) :: y   ! Values of dependent variable y.
REAL :: y0                       ! Interpolated value.

! Get the name of the file containing the input data.
WRITE (*,*) 'Enter the file name with the (x,y) data:  '  
READ (*,'(A20)') filename

! Get point x0 at which to interpolate data.
WRITE (*,*) 'Enter point x0 at which to interpolate y0: '
READ (*,*) x0

! Open input data file.  Status is OLD because the input data 
! must already exist.
OPEN ( UNIT=9, FILE=filename, STATUS='OLD', ACTION='READ', &
       IOSTAT=status )
 
! Was the OPEN successful? 
fileopen: IF ( status == 0 ) THEN       ! Open successful
 
   ! The file was opened successfully, so read the (x,y) data. 
   DO
      READ (9,*,IOSTAT=status) temp1,temp2 ! Get value
      IF ( status /= 0 ) EXIT              ! Exit on end of data 
      nvals = nvals + 1                    ! Bump count
      size: IF ( nvals <= max_size ) THEN  ! Too many values?
         x(nvals) = temp1                  ! No: Save values
         y(nvals) = temp2                  ! 
      ELSE
         exceed = .TRUE.                   ! Yes: Array overflow
      END IF size
   END DO
 
   ! Was the array size exceeded?  If so, tell user and quit.
   toobig: IF ( exceed ) THEN
      WRITE (*,1000) nvals, max_size
      1000 FORMAT (' Max array size exceeded: ', I6, ' > ', I6)
   ELSE
      ! Limit not exceeded: interpolate the data.
      CALL interp ( x, y, nvals, x0, y0, error )

      ! Now display results.
      IF ( error == 0 ) THEN
         WRITE (*,1010) x0, y0
         1010 FORMAT (' The interpolated value at x = ',ES14.6,&
                      ' is ',ES14.6,'.')
      ELSE               
         WRITE (*,1020) 
         1020 FORMAT (' ERROR--Point is outside the range of x.')
      END IF
   END IF toobig

ELSE fileopen              
   WRITE (*,1030) status 
   1030 FORMAT (' Could not open file.  status = ', I6)
END IF fileopen
 
END PROGRAM
