PROGRAM test_integrate
!
!  Purpose:
!    To test subroutine integrate, which integrates a function.  
!    The function to be integrated is passed to the subroutine
!    as a calling argument.  This driver routine will integrate
!    the function with step sizes dx of 1.0, 0.5, 0.1, 0.05, 
!    and 0.01. 
!
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    02/15/96    S. J. Chapman        Original code
!
IMPLICIT NONE

! List of variables:
REAL, DIMENSION(7) :: area   ! Area under the curve
REAL, DIMENSION(7) :: dx     ! Step size
INTEGER :: error             ! Error flag
INTEGER :: i                 ! Index variable
REAL :: x1 = 0.              ! Starting point for integral.
REAL :: x2 = 3.              ! Ending point for integral.

! Declare the external function being passed to subroutine
REAL, EXTERNAL :: test_fun

! Initialize step sizes
dx = (/ 1., 0.5, 0.1, 0.05, 0.01, 0.005, 0.001 /)

! Call subroutine "integrate" with each step size, and print  
! out the results.  
DO i = 1, 7
   CALL integrate ( test_fun, x1, x2, dx(i), area(i), error )
END DO
 
! Write out results.
WRITE (*,1000) 
1000 FORMAT ('0','  Step Size',5X,'Area',/, &
             ' ','  =========',5X,'====')
DO i = 1, 7
   WRITE (*,'(1X,F9.4,3X,F9.4)') dx(i), area(i)
END DO
 
END PROGRAM
REAL FUNCTION test_fun(x)
!
!  Purpose:
!    Function to be integrated.  
!
IMPLICIT NONE

REAL, INTENT(IN) :: x
 
! Evaluate function.
test_fun = 3 * x**2 + 0.5
 
END FUNCTION test_fun
