/*************************************************************************

    File: fol2bliksem.pl
    Copyright (C) 2004,2006 Patrick Blackburn & Johan Bos

    This file is part of BB2, version 2.0 (November 2006).

    BB2 is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    BB2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BB2; if not, write to the Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*************************************************************************/

:- module(fol2bliksem,[fol2bliksem/2]).


/*========================================================================
   Translates formula to otter syntax on Stream
========================================================================*/

fol2bliksem(Formula,Stream):-
	nonvar(Formula),
	printBliksemFormula(Stream,Formula).


/*========================================================================
   Print an Bliksem formula (introducing tab)
========================================================================*/

printBliksemFormula(Stream,F):-
	   format(Stream,'~nAuto.~n~n',[]),
	   \+ \+ (
		     numbervars(F,0,_),
		     printBliksem(Stream,F,5)
		 ),
	   format(Stream,'.~n',[]).


/*========================================================================
   Print Bliksem formulas
========================================================================*/

printBliksem(Stream,some(X,Formula),Tab):- 
   write(Stream,'(< '),
   write_term(Stream,X,[numbervars(true)]),
   write(Stream,' >'),
   printBliksem(Stream,Formula,Tab),
   write(Stream,')').

printBliksem(Stream,all(X,Formula),Tab):- 
   write(Stream,'([ '),
   write_term(Stream,X,[numbervars(true)]),
   write(Stream,' ]'),
   printBliksem(Stream,Formula,Tab),
   write(Stream,')').

printBliksem(Stream,que(X,Formula1,Formula2),Tab):- 
   write(Stream,'(< '),
   write_term(Stream,X,[numbervars(true)]),
   write(Stream,' >'),
   printBliksem(Stream,and(Formula1,Formula2),Tab),
   write(Stream,')').

printBliksem(Stream,and(Phi,Psi),Tab):- 
   write(Stream,'('),
   printBliksem(Stream,Phi,Tab), 
   format(Stream,' & ~n',[]),
   tab(Stream,Tab),
   NewTab is Tab + 5,
   printBliksem(Stream,Psi,NewTab),
   write(Stream,')').

printBliksem(Stream,or(Phi,Psi),Tab):- 
   write(Stream,'('),
   printBliksem(Stream,Phi,Tab),
   write(Stream,' | '),
   printBliksem(Stream,Psi,Tab),
   write(Stream,')').

printBliksem(Stream,imp(Phi,Psi),Tab):- 
   write(Stream,'('),  
   printBliksem(Stream,Phi,Tab),
   write(Stream,' -> '),
   printBliksem(Stream,Psi,Tab),
   write(Stream,')').

printBliksem(Stream,not(Phi),Tab):-
   write(Stream,'!'),
   printBliksem(Stream,Phi,Tab).

printBliksem(Stream,eq(X,Y),_):- 
   write(Stream,'( '),
   write_term(Stream,X,[numbervars(true)]),
   write(Stream,' = '),
   write_term(Stream,Y,[numbervars(true)]),
   write(Stream,' )').

printBliksem(Stream,pred(Sym,X),_):-
   write(Stream,Sym),
   write(Stream,'( '),
   write_term(Stream,X,[numbervars(true)]),
   write(Stream,' )').

printBliksem(Stream,rel(Sym,X,Y),_):-
   write(Stream,Sym),
   write(Stream,'('),
   write_term(Stream,X,[numbervars(true)]),
   write(Stream,','),
   write_term(Stream,Y,[numbervars(true)]),
   write(Stream,')').
