#!/usr/bin/python
import argparse
import logging
import os
import re
from string import Template
#TODO: generate init functions that return successs/failure.

log = logging.getLogger(__name__)

PASSTHROUGH_KEY = 'passthrough'
SOURCELINE_KEY = 'sourcefile'
#XXX hack
def convertEscapeChars(s):
    #print("convert newlines len(s) = %s" % (len(s)))
    newstr = ""
    i = 0

    # loop through all chars,
    # if we find \r or \n, replace the \r with the actually \r value.
    # essential read the escape value and set correctly.
    while i < len(s):
        if s[i] == '\\' and i < len(s)-1:
            #print ("[%d] hit found, i=%s, s[i] = %c"% (len(s), i, s[i]))
            #print ("i+1 = %s, s[ %s ] = %s" % (i+1, i+1, s[i+1]))
            if s[i+1] == 'r':
                #print "got an r"
                c = '\r'
                i += 1
            elif s[i+1] == 'n':
                #print "got an N"
                c = '\n'
                i += 1
            elif s[i+1] == '\"':
                c = '"'
                i += 1
            #print ("iterating")
        else:
            c = s[i]
        newstr = newstr + c
        i += 1
    #print ("done loop")

    return newstr


def obfuscateValue(c, obfuscate=True):
    v = ord(c)
    if not obfuscate:
        return hex(v)

    inv = ~v % 0xFF + 1
    return hex(inv)

def getniceobfsvalue(obfsvalue):
    value_arr = obfsvalue.split(" ")
    nicestr = "    "
    index = 0

    for index in range(0, len(value_arr)):
        if index % 16 == 0:
            nicestr = nicestr+"\n    "
        curr_val = value_arr[index]
        nicestr = nicestr + curr_val

    return nicestr

def getTupleForSrcline(srcline):
    """
    fixed(max size)      variable name    value
    #string[255]         LOADER_LIB1      "some string value"

    the max size is optional, leave out block quotes if not needed
    the size will be calculated based on the size of the string.
    Max size is useful of the string is patched out later and you want
    a bigger string in place. The patcher should append a null in this case.

    If the size of the string is specified and the calculated length are equal,
    no null is provided.
    """
    #datatype, size, name, value
    #s ="""#string[255]   LOADER_LIB1      "/private/var/root/Library/Lock/libsbox.dylib" """
    pattern = r'^(#\w*)(\[(\d*)])?\s*(\w*)\s*"(.*)"'
    p = re.compile(pattern)

    m = p.search(srcline)

    if not m:
        #print "match fail"
        return None
    #print m.groups()
    datatype, throwaway, sizestr, name, value = m.groups()
    orig_value = value
    # only know about string for now
    if not (datatype.startswith("#string") or datatype.startswith("#cfstringref")):
        return None
    # cleanup value and escape characters
    value = value.strip()
    value = convertEscapeChars(value)
    # convert to list for easier handling.
    valueList = []
    for c in value:
        valueList.append(c)
    value = valueList

    # calculate the size variable. size does not take into account escape characters
    size = len(value)
    if sizestr is not None:
        size = int(sizestr)
        if size < len(value):
            raise ValueError("your string is bigger than your max size for %s" % name)

    # if no fixed size is given and the size is read in is not the same, append a null
    if sizestr is None or size != len(value):
        value.append('\0')
        size = size + 1
    # DEBUG TODO
    #return ("#string", size, name, value, orig_value)
    return (datatype, size, name, value, orig_value)

def addblanksToList(val, maxsz):
    for i in range(0, maxsz-len(val)):
        val.append("0xff")

def parse_stringsfile(inputfile):
    """
    input: file like object of strings definition
    returns a list of items that may go into the header, the src, or both.
        the list contains items in the following format
        ('h|s|hs', (datatuple))

    if p, then line is pass through to the header file (#defines usually)
    if s, then line only goes to source and header for definitions
    """

    parsed = []

    for line in inputfile:
        line = line.strip()
        # skip any comments
        if line.startswith("//") or len(line) == 0:
            continue

        if line.strip().startswith("#endif"):
            raise ValueError("Found an #endif in file:{}".format(inputfile.name))

        datatuple = getTupleForSrcline(line)

        # if parse was not successful, pass line through to header file
        if datatuple is None:
            parsed.append((PASSTHROUGH_KEY, line))
            continue

        parsed.append((SOURCELINE_KEY, datatuple))
    return parsed

header_templ = Template(r"""
// ********** DO NOT MODIFY - autogenerated
#ifndef ${name}__GUARD__
#define ${name}__GUARD__

#import <CoreFoundation/CoreFoundation.h>

$passthrough
$declarations

void ${name}_cf_init(void);
void ${name}_init(void);
void ${name}_free(void);

#endif
""")

sourcefile_templ = Template(r"""
// ********** DO NOT MODIFY - autogenerated

#import "${outputfilename}.h"

#import <asl.h>   // debug
#import <stdbool.h>

//#define _dlog(fmt, ...) asl_log(NULL,NULL,ASL_LEVEL_EMERG, "%3d - %s: " fmt, __LINE__, __func__, ##__VA_ARGS__)
#define _dlog(fmt, ...) do {} while(0)
bool ${name}_hasRun = false;
bool ${name}_hasCF = false;
static void unobfs_str(char *str, int len)
{
    int i;
    for (i = 0; i < len; i++) {
        //_dlog("before [%3d] 0x%x", i, str[i]);
        str[i] = ~str[i];
        //_dlog("after  [%3d] 0x%x", i, str[i]);
    }
}
// begin declarations
$declarations
// end declarations

void ${name}_cf_init(void) {
$cfinitlines
}

//void ${name}_init(void)
void __attribute__((constructor)) ${name}_init(void)
{
    _dlog("has_run = (%p) %d", &${name}_hasRun, ${name}_hasRun);
    if (!${name}_hasRun) {
        _dlog("initing for realz");
        ${name}_hasRun = true;
${initlines}
    }
    if (!${name}_hasCF) {
        _dlog("cfing");
        ${name}_hasCF = true;
        ${name}_cf_init();
    }
    _dlog("finished init for ${name}");
}

void ${name}_free(void)
{
if (${name}_hasCF) {
    _dlog("${name}_free");
    ${name}_hasCF = false;
$freelines
    }
}
""")

decl_templ = Template(r"""
char ${varname}[${size}] = { /* ${origvalue} */ $bytes };""")

cf_initdecl = Template(r"""    //_dlog("b - CF_${name} ptr (%p) = %p", &CF_${name}, CF_${name});
    if (CF_${name} == NULL) {
        CF_${name} = CFStringCreateWithCStringNoCopy(
                kCFAllocatorDefault,
                ${name},
                kCFStringEncodingUTF8,
                kCFAllocatorNull);
        //_dlog("a - CF_${name} ptr (%p) = %p, first byte = 0x%x", &CF_${name}, CF_${name}, ${name}[0]);
    }
""")

free_cf_templ = Template(r"""    //_dlog("f - CF_${name} ptr (%p) == %p", &CF_${name}, CF_${name});
    if (CF_${name} != NULL) { CFRelease(CF_${name}); CF_${name} = NULL; } """)

init_templ = Template(r"""        //_dlog("debofs ${name} (%p)", &${name});
        unobfs_str(${name}, ${name}_len);""")


def get_headerfile(parsedlines, name):

    passthrough = []
    declarations = []
    for parsedline in parsedlines:
        if parsedline[0] == PASSTHROUGH_KEY:
            passthrough.append(parsedline[1])
            continue
        (datatype, size, varname, valuelist, orig_value) = parsedline[1]
        declarations.append("// %s=%s" % (varname, orig_value))
        declarations.append("#define %s_len %d" % (varname, size))
        declarations.append("extern char {name}[{name}_len];".format(name=varname))
        if datatype == "#cfstringref":
            declarations.append("extern CFStringRef CF_{name};".format(name=varname))

    header = header_templ.substitute(
        name = name,
        passthrough = '\n'.join(passthrough),
        declarations = '\n'.join(declarations)
    )
    return header

def get_sourcefile(parsedlines, outputfilename, name, obfuscate):

    sourceonly = [sourceline[1] for sourceline in parsedlines if sourceline[0] == SOURCELINE_KEY]

    def get_decl():
        decls = []
        for datatype, size, varname, valuelist, orig_value in sourceonly:

            valuelist = [obfuscateValue(v, obfuscate) for v in valuelist]
            addblanksToList(valuelist, size)
            nice = getniceobfsvalue(", ".join(valuelist))

            decls.append(decl_templ.substitute(
                varname=varname,
                origvalue=orig_value,
                size=size,
                bytes=nice
            ))
            if datatype == "#cfstringref":
                # __attribute__((section("__DATA, __data")))
                decls.append('CFStringRef CF_{name} = NULL;'.format(name=varname))
        return "\n".join(decls)

    def get_code(templ, for_datatype):
        l = []
        for datatype, size, varname, valuelist, orig_value in sourceonly:
            if datatype in for_datatype:
                l.append(templ.substitute(
                    name = varname
                ))
        return "\n".join(l)

    initlines = " "
    if obfuscate:
        initlines = get_code(init_templ, ("#string", "#cfstringref"))
    sourcefile = sourcefile_templ.substitute(
        name=name,
        outputfilename=os.path.basename(outputfilename),
        declarations=get_decl(),
        cfinitlines=get_code(cf_initdecl, "#cfstringref"),
        initlines=initlines,
        freelines=get_code(free_cf_templ, "#cfstringref"),

    )
    return sourcefile

def generateCode(inputfilename, outputfilename, projheaders, obfuscate=True):
    with open(inputfilename, 'r') as f:
        parsedlines = parse_stringsfile(f)
        headerfile = get_headerfile(parsedlines, projheaders)
        sourcefile = get_sourcefile(parsedlines, outputfilename, projheaders, obfuscate)

        dirname = os.path.dirname(outputfilename)
        try:
            os.makedirs(dirname)
        except OSError:
            pass  # already exists
        outfile = open(outputfilename+".h", "w")
        outfile.write(headerfile)
        outfile.close()

        outfile = open(outputfilename+".c", "w")
        outfile.write(sourcefile)
        outfile.close()
        print "###########wrote %s.h" % (outputfilename)
        print "###########wrote %s.c" % (outputfilename)

    return

def main():
    logging.basicConfig()
    p = argparse.ArgumentParser()
    p.add_argument('-n', '--noobfuscate', action='store_true', help="don't obfuscate")
    p.add_argument('-v', '--verbose', action='count', help='Verbosity')
    p.add_argument('inputfile', help='source of strings')
    p.add_argument('outputfile', help='full output name without extension. ex: /path/to/custom_str')

    args = p.parse_args()

    if args.verbose > 1:
        log.setLevel(logging.DEBUG)
    elif args.verbose == 1:
        log.setLevel(logging.INFO)

    name = os.path.basename(args.outputfile.replace('.', '_'))
    log.debug("options = {}".format(args))
    generateCode(args.inputfile,
                 args.outputfile,
                 name,
                 not args.noobfuscate)

if __name__ == "__main__":
    main()
