/////////////////////////////////////////////////////////////////////////////////////
//                                                                                 //
//                                 RSS-ticker functions                            //
//                                                                                 //
/////////////////////////////////////////////////////////////////////////////////////

// The pause in milliseconds between each news item
var pause = 5000;

// Global variables
var itemsList, request;

function initRssTicker() {
  if (!document.getElementsByTagName) {
    error('document.getElementsByTagName doesn\'t exist!');
    return;
  }

  var anchors = document.getElementsByTagName('a');
  if (!anchors || (anchors.length == 0)) {
    error('No anchors found');
    return;
  }

  for (var i = 0; i < anchors.length; i++) {
    var a = anchors[i];
    if (!a || !a.href || !a.type || !a.className ||
        (a.className != 'rss-ticker') ||
        (a.type != 'application/rss+xml')) {
        info('Continues because the anchor\'s class-name or type is not correct');
        continue;
    }

    request = new XMLHttpRequest();
    loadRssFeed(a);
  }
} // initRssTicker

function loadRssFeed(anchor) {
  info('loadRssFeed()');

  if (!request) return;

  removeChildren(anchor);
  itemsList = new Array();

  request.onreadystatechange = function() {
    if ((request.readyState == 4) && (request.status == 200) && request.responseXML) {
      try {
        var items = request.responseXML.getElementsByTagName('item');
        var o     = {
          items   : items,
          anchor  : anchor
        };

        var itemsIndex = itemsList.push(o) - 1;
        writeRssItem(itemsIndex, 0);
      } catch (e) {
        error(e.message);
      }
    }
  };

  request.open('GET', anchor.href);
  request.send(null);
} // loadRssFeed

function removeChildren(element) {
  for (var i = 0; i < element.childNodes.length; i++) {
    var child = element.childNodes[i];
    info('Removing child ' + child.nodeName);
    element.removeChild(child);
  }
}

function writeRssItem(itemsListIndex, itemIndex) {
  var item      = getItem(itemsListIndex, itemIndex);
  var title     = (item['title'] ? item['title'] : '');
  var parent    = item['parent'];
  var anchor    = parent['anchor'];
  var itemCount = parent['items'].length;
  var timeout   = (90 * title.length) + pause;

  removeChildren(anchor);
  anchor.setAttribute('href', item['link']);
  anchor.setAttribute('title', 'Klikk her for \xE5 lese mer om \xAB' + title + '\xBB.');
  info('Writing item ' + itemIndex + ' of ' + parent['items'].length + ': "' + title + '"');
  writeRssItemTextLetter(itemsListIndex, itemIndex, 0);
} // writeRssItem

function writeRssItemTextLetter(itemsListIndex, itemIndex, letterIndex) {
  var item      = getItem(itemsListIndex, itemIndex);
  var title     = (item['title'] ? item['title'] : '');
  var parent    = item['parent'];
  var anchor    = parent['anchor'];
  var itemCount = parent['items'].length;

  var item  = getItem(itemsListIndex, itemIndex);
  if (!item) return;
  var anchor = item['parent']['anchor'];
  var title  = item['title'];
  if (!anchor) return;
  var textNode = getTextNode(anchor);

  if (!textNode) {
    textNode = document.createTextNode('');
    anchor.appendChild(textNode);
  }

  itemIndex = parseInt(itemIndex, 10);
  letterIndex = parseInt(letterIndex, 10);

  if (textNode.appendData) {
    var letter = title.substring(letterIndex, letterIndex + 1);
    textNode.appendData(letter);
    letterIndex++;

    if (letterIndex < title.length) {
      window.setTimeout('writeRssItemTextLetter(' + itemsListIndex + ',' +
        itemIndex + ',' + letterIndex + ')', 90);
    }
    else {
      itemIndex++;

      if (itemIndex == itemCount) {
        info('Reloading the feed because we\'re out of items');
        itemIndex = 0;
        loadRssFeed(anchor);
      }
      else {
        window.setTimeout('writeRssItem(' + itemsListIndex + ',' + itemIndex + ')', pause);
      }
    }
  } else {
    error('!textNode.appendData');
  }
} // writeRssItemTextLetter

function getItem(itemsListIndex, itemIndex) {
  var o       = itemsList[itemsListIndex];
  var items   = o['items'];
  if (!items || (items.length == 0)) return null;
  if (itemIndex == items.length) itemIndex = 0;
  var item    = items[itemIndex];
  if (!item) return null;
  var title   = getTextValue(item, 'title');
  var link    = getTextValue(item, 'link');

  if (title) {
    title = title.replace(/(^\s+)|(\s+$)/gi, '');
  }

  var itemObj = {
    title   : title,
    link    : link,
    parent  : o
  };

  return itemObj;
} // getItem

function getTextNode(element) {
  if (!element || !element.childNodes ||
      (element.childNodes.length == 0)) {
    warn('getTextNode(' + element.nodeName + '): no children');
    return null;
  }

  for (var i = 0; i < element.childNodes.length; i++) {
    var child = element.childNodes[i];
    if (child.nodeType == 3) return child;
  }
} // getTextNode

function getTextValue(parentNode, tagName) {
  var nodes = parentNode.getElementsByTagName(tagName);
  if (!nodes || (nodes.length == 0)) return null;
  var node = nodes[0];
  return getTextNode(node).nodeValue;
} // getTextValue

addEvent(window, 'load', initRssTicker);