require File.dirname(__FILE__) + '/../test_helper'

# We are testing BlogController's views
class BlogViewTest < Test::Rails::ViewTestCase

  fixtures :users, :settings, :topics, :comments
 
  def setup
    super
    assigns[:current_user] = users(:visitor1)
  end
 
  def test_index
    assigns[:blog_font_page_greeting]     = Snippet.find_or_create_by_name('blog_font_page_greeting')
    assigns[:topics]                      = Topic.find(:all)
    assigns[:most_read_comments]          = Comment.find(:all, :limit => 3)
    assigns[:highest_rated_comments]      = Comment.find(:all, :limit => 3)
    assigns[:newest_comments]             = Comment.find(:all, :limit => 3)
    assigns[:ten_best_rated_participants] = []
 
    render :action => 'index'

    assert_links_to "/topics/show/#{topics(:direct_democracy).id}", "Read the full piece &raquo;"
    assert_links_to '/archives', "Previous Entries"
  end
  
  def test_index_no_comments
    assigns[:blog_font_page_greeting]     = Snippet.find_or_create_by_name('blog_font_page_greeting')
    assigns[:topics]                      = Topic.find(:all)
    assigns[:most_read_comments]          = []
    assigns[:highest_rated_comments]      = []
    assigns[:newest_comments]             = []
    assigns[:ten_best_rated_participants] = []
 
    render :action => 'index'
  end
  
  def test_comment_partial
    assigns[:comment] = comments(:day_old_reply)
    render :partial => 'comment'
    
    assert_links_to "/topics/show/1#comment_#{comments(:day_old_reply).id}"
  end
  
  def test_topic_partial
    assigns[:topic] = topics(:direct_democracy)
    
    render :partial => 'topic'
    
    assert_links_to "/topics/show/#{topics(:direct_democracy).id}", topics(:direct_democracy).title
    assert_links_to "/topics/show/#{topics(:direct_democracy).id}", "Read the full piece &raquo;"
  end
end
