require File.dirname(__FILE__) + '/../test_helper'

class ReadingTest < Test::Rails::TestCase
  fixtures :readings, :users, :support_materials, :comments


  def test_create_support_materials_reading
    assert_difference(Reading, :count) do
      users(:ernest).readings.create(:readable => support_materials(:google))
    end
  end
  
  def test_only_create_one_per_user_support_material_combination
    assert_difference(Reading, :count) do
      users(:ernest).readings.create(:readable => support_materials(:google))
      users(:ernest).readings.create(:readable => support_materials(:google))
    end
  end
  
  def test_dependent_on_support_material
    assert_difference(Reading, :count, '', -1) do
      SupportMaterial.destroy(support_materials(:msn).id)
    end    
  end
  
  def test_can_create_multiple_readings_on_comments
    assert_difference(Reading, :count, '', 2) do
      users(:ernest).readings.create(:readable => comments(:long_first_post))
      users(:ernest).readings.create(:readable => comments(:long_first_post))
    end
  end
  
  def test_dependent_on_comment
    assert_difference(Reading, :count, '', -3) do
      Comment.destroy(comments(:long_first_post).id)
    end    
  end
  
  def test_move_to_new_user_no_net_change
    assert_no_difference(Reading, :count) do
      Reading.move_to_new_user(users(:visitor1), users(:ernest))
    end
  end

  def test_move_to_new_user_readings_moved
    assert_difference(users(:visitor1).readings, :count, '', -2) do
      assert_difference(users(:ernest).readings, :count, '', 2) do
        Reading.move_to_new_user(users(:visitor1), users(:ernest))
      end
    end
  end
  
  def test_find_most_read_id_comment
    assert_nothing_raised { Reading::find_most_read_id(:comment) }
    assert_equal comments(:long_first_post).id, Reading::find_most_read_id(:comment) 
  end
  
  def test_find_most_read_id_comment_no_readings
    Reading.delete_all
    assert_nothing_raised { Reading::find_most_read_id(:comment) }
    assert Reading::find_most_read_id(:comment).nil?
  end
  
  def test_find_most_read_id_support_material
    assert_nothing_raised { Reading::find_most_read_id(:support_material) }
    assert_equal support_materials(:msn).id, Reading::find_most_read_id(:support_material) 
  end
  
  def test_find_most_read_id_support_material_no_readings
    Reading.delete_all
    assert_nothing_raised { Reading::find_most_read_id(:support_material) }
    assert Reading::find_most_read_id(:support_material).nil?
  end
  
end
