require File.dirname(__FILE__) + '/../test_helper'

class CommentSpecificationTest < Test::Rails::TestCase
  fixtures :ratings, :users, :comments, :topics

  def test_subject_commentable_comment
    assert CommentSpecification::subject_commentable(comments(:first_post), users(:grace))
  end

  #def test_subject_commentable_comment_hidden
  #  assert CommentSpecification::subject_commentable(comments(:first_post), users(:grace))
  #end

  def test_subject_commentable_topic
    assert CommentSpecification::subject_commentable(topics(:direct_democracy), users(:grace))
  end
  
  def test_subject_commentable_topic_in_future
    assert !CommentSpecification::subject_commentable(topics(:guilty_looks), users(:grace))
  end
  
  def test_guest_is_not_registered
    assert !CommentSpecification::user_is_registered(topics(:guilty_looks), users(:visitor1))
  end

  def test_participant_is_registered
    assert CommentSpecification::user_is_registered(topics(:guilty_looks), users(:grace))
  end
  
  def test_expert_is_registered
    assert CommentSpecification::user_is_registered(topics(:guilty_looks), users(:frank))
  end
  
  def test_admin_is_registered
    assert CommentSpecification::user_is_registered(topics(:guilty_looks), users(:laura))
  end
  
  # # comment
  # def test_subject_has_been_comment_rated
  #   assert !CommentSpecification::subject_has_required_rating(comments(:first_post), users(:grace)) # not yet
  # end
  # 
  # def test_subject_has_been_rated_comment_again
  #   assert CommentSpecification::subject_has_required_rating(comments(:first_reply), users(:grace)) # :first
  # end 
  # 
  # # topic
  # def test_subject_has_been_rated_topic
  #   assert !CommentSpecification::subject_has_required_rating(topics(:direct_democracy), users(:ernest)) # rated nothing
  # end
  # 
  # def test_subject_has_been_rated_topic_again
  #   assert CommentSpecification::subject_has_required_rating(topics(:direct_democracy), users(:grace)) #:third
  # end
  
end
