require File.dirname(__FILE__) + '/../test_helper'

class AbstractRatingTest < Test::Rails::TestCase
  fixtures :ratings, :comments, :users, :topics
  
  def test_best_average_rated_subject_id
    assert_nothing_raised { AbstractRating.best_average_rated_subject_id }
  end
  
  def test_best_average_rated_subject_ids
    assert_nothing_raised { AbstractRating.best_average_rated_subject_ids }
  end
  
  def test_best_average_rated_subject_ids_returns_three_ids
    results = AbstractRating.best_average_rated_subject_ids
    assert_equal 3, results.length
  end
  
  def test_best_average_rated_subject_ids_returns_n_ids
    results = AbstractRating.best_average_rated_subject_ids(5)
    assert_equal 5, results.length
  end
  
  def test_best_average_rated_subject_ids_correct_results
    results = AbstractRating.best_average_rated_subject_ids
    assert_equal [1, 2, 4], results
  end
  
  def test_move_to_new_user_no_net_change
    assert_no_difference(Reading, :count) do
      AbstractRating.move_to_new_user(users(:visitor1), users(:ernest))
    end
  end

  def test_move_to_new_user_readings_moved
    assert_difference(users(:visitor1).ratings, :count, '', -1) do
      assert_difference(users(:ernest).ratings, :count, '', 1) do
        AbstractRating.move_to_new_user(users(:visitor1), users(:ernest))
      end
    end
  end
  
  def test_ratings_dependent_on_user
    assert_difference(AbstractRating, :count, '', -6) do
      users(:ernest).destroy
    end
  end
  
end
