require File.dirname(__FILE__) + '/../test_helper'

class CommentHelperTest < HelperTestCase

  include CommentHelper
  include ActionView::Helpers::DateHelper
  include ApplicationHelper

  fixtures :users, :comments, :topics

  def setup
    super
    User.current_user = users(:quentin)
  end
  
  def test_commenter_name
    assert_match 'Ernest', commenter_name(comments(:first_post))
  end
  
  def test_commenter_role
    assert commenter_role(comments(:first_post)).nil?
    #assert_match '(expert)', commenter_role(comments(:first_post)) # TODO create a comment fixture to match this test
    assert_match '(moderator)', commenter_role(comments(:long_first_post))    
  end
  
  def test_commenter_role_for_nik
    nik = Expert.new(:name => 'Nik Nanos')
    niks_comment = Comment.new(:user => nik)
    output = commenter_role(niks_comment)
    assert_match '(the pollster)', output
  end
  
  def test_comment_permalink
    assert_nothing_raised { comment_permalink(comments(:first_post)) }
    output = comment_permalink(comments(:first_post))
    assert_match 'class="comment-permalink"', output
    assert_match '/topics/show/1#comment_1', output
  end
  
  def test_timestamp
    assert_nothing_raised { timestamp(comments(:day_old_reply)) }
    output = comment_permalink(comments(:day_old_reply))
    assert_match 'class="comment-timestamp"', output
    assert_match '1 day ago', output
  end
  
  def test_comment_info
    assert_nothing_raised { comment_info(comments(:long_first_post)) }
    output = comment_info(comments(:long_first_post))
    assert_match 'comment-permalink', output
    assert_match '(moderator)', output
    assert_match 'Laura', output
  end
  
  def test_comment_info_province
    output = comment_info(comments(:long_first_post))
    assert_match "Nunavut", output
  end
  
  def test_comment_class
    { :first_post => 'participant',
      :long_first_post => 'admin',
      :second_reply => 'expert' 
    }.each_pair do |comment_symbol, class_name|
      assert_equal class_name, comment_class(comments(comment_symbol)).to_s
    end
  end

  # def test_comment_teaser
  #   raise NotImplementedError, 'Need to write test_comment_teaser'
  # end
  # 
  # def test_comment_tools
  #   raise NotImplementedError, 'Need to write test_comment_tools'
  # end
  # 
  # def test_hot_comment
  #   raise NotImplementedError, 'Need to write test_hot_comment'
  # end
  # 
  # def test_hot_comment_link
  #   raise NotImplementedError, 'Need to write test_hot_comment_link'
  # end
  # 
  # def test_join_hide_conversation_toggle_link
  #   raise NotImplementedError, 'Need to write test_join_hide_conversation_toggle_link'
  # end
  # 
  # def test_remove_link
  #   raise NotImplementedError, 'Need to write test_remove_link'
  # end
  # 
  # def test_reply_link
  #   raise NotImplementedError, 'Need to write test_reply_link'
  # end
  
end
