require File.dirname(__FILE__) + '/../test_helper'
require 'blog_controller'

# Re-raise errors caught by the controller.
class BlogController; def rescue_action(e) raise e end; end

class BlogControllerTest < Test::Rails::ControllerTestCase
  
  fixtures :users, :settings, :topics, :comments
    
  def test_index
    login_as :quentin
    get :index
    
    assert_response :success
    assert_assigned :topics 
    assert_assigned :blog_font_page_greeting 
    # ensure they're in the right order
    assert_equal assigns(:topics), assigns(:topics).sort{|x,y| x.start_date <=> y.start_date }
  end

end
