require File.dirname(__FILE__) + '/../test_helper'

class SystemControllerTest < Test::Rails::ControllerTestCase

  fixtures :topics, :users, :settings, :support_materials, :readings

  # only admin can access the system controller
  def test_redirect_participant
    login_as :ernest # a participant
    get :index
    assert_response :redirect
  end

  def test_redirect_expert
    login_as :frank # an editor
    get :index
    assert_response :redirect
  end
  
  def test_permit_admin
    login_as :laura # an admin
    get :index
    assert_response :success
  end
  
  [:topic, :support_material, :participant, :user, :comment, :rating, :comment_reading, :support_material_reading].each do |export|
    define_method("test_export_#{export}") do
      assert_nothing_raised { get :export, :model => export}
    end
  end
  
end