module PermissionSystem
  
  # Does the current action require any specific permission?
  def action_requires_permission? 
    false
  end
  # this could be a DSL?
  # require_role :admin  # all methods
  # require_role [:admin, :editor], :methodA, :methodB
  # add :except and :only
  
  # Does the given role permit the current action?
  def action_permitted?
    current_user.has_permission_to? "#{controller_name}_#{action_name}".to_sym
  end
  
  def permision_required
    # skip permission check if action is not protected
    return true unless action_requires_permission?
    
    return true if action_permitted?
    
    logger.info "returning false from permision_required"
    # TODO do something other than just returning false -- return to a safe action
    access_denied and return false
  end

end