# Be sure to restart your web server when you modify this file.

# Uncomment below to force Rails into production mode when 
# you don't control web/app server and can't set it the proper way
# ENV['RAILS_ENV'] ||= 'production'

# Bootstrap the Rails environment, frameworks, and default configuration
require File.join(File.dirname(__FILE__), 'boot')

Rails::Initializer.run do |config|
  # Settings in config/environments/* take precedence those specified here
  
  # Skip frameworks you're not going to use
  config.frameworks -= [ :action_web_service ]

  # Add additional load paths for your own custom dirs
  #config.load_paths += %W( #{RAILS_ROOT}/app/observers #{RAILS_ROOT}/app/specifications )
  # not working -- instead add each path one at a time.
  #config.load_paths += ["#{RAILS_ROOT}/app/observers" ]
  
  config.autoload_paths += Dir[RAILS_ROOT + '/app/observers/']
  config.autoload_paths += Dir[RAILS_ROOT + '/app/specifications/']

  config.active_record.observers = :comment_observer, :user_observer, :comment_rating_observer
  
  # Force all environments to use the same logger level 
  # (by default production uses :info, the others :debug)
  # config.log_level = :debug
  config.logger = Logger.new("#{RAILS_ROOT}/log/#{RAILS_ENV}.log", 50, 1_000_000)
  
  # Use the database for sessions instead of the file system
  # (create the session table with 'rake create_sessions_table')
  # config.action_controller.session_store = :active_record_store
  
  # see http://railsexpress.de/svn/plugins/sql_session_store/trunk/README
  config.action_controller.session_store = :sql_session_store
  
  # Use SQL instead of Active Record's schema dumper when creating the test database.
  # This is necessary if your schema can't be completely dumped by the schema dumper, 
  # like if you have constraints or database-specific column types
  # config.active_record.schema_format = :sql

  # Activate observers that should always be running
  # config.active_record.observers = :cacher, :garbage_collector
  #config.active_record.observers = :comment_observer, :user_observer
  
  # Make Active Record use UTC-base instead of local time
  # config.active_record.default_timezone = :utc
  
  # See Rails::Configuration for more options

  config.action_mailer.delivery_method = :sendmail

end

# Add new inflection rules using the following format 
# (all these examples are active by default):
# Inflector.inflections do |inflect|
#   inflect.plural /^(ox)$/i, '\1en'
#   inflect.singular /^(ox)en/i, '\1'
#   inflect.irregular 'person', 'people'
#   inflect.uncountable %w( fish sheep )
# end

# Include your application configuration below
ActiveRecord::Base.observers = CommentObserver, UserObserver

SqlSessionStore.session_class = MysqlSession

require 'rubypants'
