# specification for rating comments, topics and support_materials
class RatingSpecification
  extend Specification
  # TODO remane user_allowed_to_rate
  satisfies :user_is_a_participant_or_guest, 'only participants and guests can rate' do |subject, rater, rating_class|
    [:participant, :guest].include? rater.role
  end

  satisfies :subject_rateable, 'subject is not rateable' do |subject, rater, rating_class|
    subject.rateable? # Topic, Comment and SupportMaterial need to implement this method
  end
  
  satisfies :not_already_rated, 'you have already rated this' do |subject, rater, rating_class|
    !rater.ratings.any?{|r|
      r.class == rating_class && r.subject == subject 
    } rescue true # in case expert/admin tries to rate
  end
  
  # only applies to comments (not topics or support material)
  satisfies :user_not_self_rating, 'cannot rate your own comment' do |subject, rater, rating_class|
    subject.is_a?(Comment) ? (subject.user != rater) : true
  end
  
end