# Specifications for commenting on comments and topics
class CommentSpecification
  extend Specification

  satisfies :user_is_registered, 'only registered/logged in users can comment' do |subject, user|
    user.registered?
  end

  satisfies :subject_commentable, 'subject is not approved' do |subject, user|
    subject.commentable?
  end
  
  # divorce rating from commenting -- allow either or
  # # since users can only rate something once, subsequent comments are rating-free
  # satisfies :subject_has_required_rating, 'please rate the subject first' do |subject, user|
  #   if user.role == :participant && RatingSpecification::user_not_self_rating(subject, user)
  #     user.ratings && user.ratings.any?{|r| r.subject == subject}
  #   else
  #     true # users don't need to rate their own comments
  #   end
  # end
end