module MetricsHelper
  
  # the second(common) half of the comment row
  def comment_row_common(comment)
    s = String.new
    s << content_tag(:td, truncate(comment.topic.title))
    s << content_tag(:td, comment.user.name)
    s << content_tag(:td, link_to(truncate(comment.body), 
          {
              :controller => 'topics',
              :action => 'show',
              :id => comment.topic.id,
              :anchor => "comment_#{comment.id}" 
          }
        )
      )
  end
    
  # returns the HTML code for a single row form the metrics grid
  def topic_attribute_row(metrics_grid, topic)
    [:comment_count, :comment_words, :rating_count, :rating_mean ].collect do |name|
      stats = metrics_grid.for_topic(topic)
      value = stats[name]
      td_html_attributes = {:class => 'max'} if metrics_grid.is_best?(name, value)
      content_tag(:td, 
        value.nil? ? '-' :  value,
        td_html_attributes)
    end.join("\n")
  end
end
