class SystemController < ApplicationController
  before_filter :permision_required
  
  def show
    @data = TableDumper::get_data(params[:model])
  end
  
  # The DialogSpace is considered closed if Settings.open is anything that equates to false
  def on_off
    if request.post? && params[:open]
      Settings.open = params[:open] == "yes" ? true : false
      flash[:alert] = "DialogSpace now opened" if Settings.open
      redirect_to :action => 'on_off'
    end
    Settings.reload
  end
  
  def settings
    return unless request.post?
    Settings.consultation_name        = params[:consultation_name]
    Settings.consultation_description = params[:consultation_description]
    Settings.application_url          = params[:application_url]
    Settings.admin_email              = params[:admin_email]
    Settings.email_subject_label      = params[:email_subject_label]
    flash[:notice] = "Settings saved"
    redirect_to :action => 'index'
  end
  
  def export
    send_data CsvWritter::array_of_AR_to_CSV(TableDumper::get_data(params[:model])), 
      :type => 'text/csv',
      :disposition => 'attachment', 
      :filename => "export-#{params[:model]}.csv"
  end

  
  # Does the current action require any specific permission?
  def action_requires_permission?
    true
  end
  
end
