class LibraryController < ApplicationController
  before_filter :permision_required 

  verify :params => "id",
         :except => :index,
         :add_flash => { :alert => "Missing required information" },
         :redirect_to => { :action => :index }
  
  def index 
    @topics = current_user.topics_find(:all, :order => 'start_date DESC', :include => :support_materials)
  end

  def new
    topic = Topic.find(params[:id])
    @support_material = topic.support_materials.build(params[:support_material])
    if request.post? && @support_material.save
      flash[:notice] = 'Support Material Created'
      redirect_to :action => 'index'
    end      
  end

  def edit
    @support_material = SupportMaterial.find(params[:id])
    @support_material.attributes = params[:support_material]
    if request.post? && @support_material.save
      flash[:notice] = "Support Material updated"
      redirect_to :action => 'index'
    end    
  end
  
  def remove
    if SupportMaterial.destroy(params[:id])
      flash[:notice] = 'Support Material Removed'
    end
    redirect_to :action => 'index'
  end
  
  private
  
  def action_requires_permission?
    action_name != 'index'
  end
  
end
