# Filters added to this controller will be run for all controllers in the application.
# Likewise, all the methods added will be available for all controllers.
class ApplicationController < ActionController::Base
  [ExceptionLoggable, AuthenticatedSystem, PermissionSystem].each { |mod| include mod }
  
  before_filter :login_required, :setup_userstamp, :logout_suspended_users
  
  session :session_key => 'nikonthenumbers_session_id'
  
  helper UniformLinkHelper
  helper RaterHelper
    
  protected
         
  def guest?
    current_user.instance_of? Guest
  end
  
  # for userstamp plugin
  def setup_userstamp
    User.current_user = current_user
  end
  
  # if a user gets flagged as 'suspended' while they are already in session, kick them out
  def logout_suspended_users
    if current_user.suspended? 
      reset_session
      redirect_to logout_url
      return false
    end
  end
end
