require File.dirname(__FILE__) + '/../test_helper'
require 'mocha'
require 'stubba'

class AvatarsViewTest < Test::Rails::ViewTestCase

 def test_new_no_existing_avatar
   assigns[:current_user] = stub(:avatar => false, :name => 'Joe')
   assigns[:avatar]       = Avatar.new

   render :action => "new"
     
   assert_no_tag :h3, :content => 'Current Avatar'     
 end

 def test_new_existing_avatar
   assigns[:current_user] = stub(
    :avatar => stub(:public_filename => '/avatars/cat.gif', :new_record? => false),
    :name => 'Joe'
    )
   assigns[:avatar] = Avatar.new

   render :action => "new"
     
   assert_tag :h3, :content => 'Current Avatar'     
   assert_tag :img, :attributes => {:src => '/avatars/cat.gif' }
 end
end
