require File.dirname(__FILE__) + '/../test_helper'

class WhitelistFilterItemTest < Test::Rails::TestCase
  fixtures :registration_filter_items

  def test_match_eh
    assert WhitelistFilterItem.match?('quire@example.com')
  end

  def test_match_eh_fails
    assert !WhitelistFilterItem.match?('sally@emaple.net')
  end
  
  def test_add_in_bulk
    assert_difference(WhitelistFilterItem, :count, nil, 3) { bulk_import }
  end
  
  def test_add_in_bulk_returns_number_of_new_records
    results = bulk_import
    assert_equal 3, results[:new_items_count]
  end
  
  def test_add_in_bulk_returns_list_of_failed_imports
    results = bulk_import
    assert results[:failed_saves]
    assert_equal 2, results[:failed_saves].length
  end
  
  def test_add_in_bulk_over_association_sets_topic
    create_fixtures :topics
    t = Topic.find(1)
    assert_difference(t.whitelist_filter_items, :count, '', 3) do
      t.whitelist_filter_items.add_in_bulk(fixture_file_upload('files/whitelist_emails.txt'))
    end
  end
  
  def test_matching_users
    create_fixtures :users
    assert_equal 1, WhitelistFilterItem.new(:value => 'quentin@example.com').matching_users.length
    assert_equal 0, WhitelistFilterItem.new(:value => 'nobody@nowhere.net').matching_users.length
  end

  def test_find_for_user
    assert_equal 1, WhitelistFilterItem.find_for_user(User.new(:email => 'quire@example.com')).length
  end
  
  def bulk_import
    WhitelistFilterItem.add_in_bulk(fixture_file_upload('files/whitelist_emails.txt'))    
  end
end
