require File.dirname(__FILE__) + '/../test_helper'

class RegistrationFilterItemTest < Test::Rails::TestCase
  fixtures :registration_filter_items, :topics, :users
  

  def test_generate_new_access_passes_called_on_save
    assert_difference(AccessPass, :count) do
      filter_item = RegistrationFilterItem.new()
      filter_item.stubs(:matching_users).returns([User.new])
      filter_item.save
    end
  end

  def test_generate_new_access_passes_sets_topic
    AccessPass.destroy_all
    dd = Topic.find(1)

    filter_item = RegistrationFilterItem.new(:topic => dd)
    filter_item.stubs(:matching_users).returns([User.new])
    filter_item.save

    assert_equal dd.id, AccessPass.find(:first).topic.id
  end

  def test_find_for_user
    assert_equal 1, RegistrationFilterItem.find_for_user(User.new(:email => 'bob@parl.gc.ca')).length
  end
end
