require File.dirname(__FILE__) + '/../test_helper'

class MaterialConvincingRatingTest < Test::Rails::TestCase
  fixtures :ratings, :users, :support_materials
    
  def test_ratings_are_dependent_on_support_material
    assert_difference(AbstractRating, :count, '', -2) do
      SupportMaterial.destroy(support_materials(:google).id)
    end    
  end

  def test_material_rating
    assert_valid new_rating
  end
  
  def test_created_with_given_user
    assert_equal users(:grace), create_rating(:user => users(:grace)).user
  end
  
  def test_cannot_rate_material_twice
    assert_no_difference(MaterialConvincingRating, :count) do
      create_rating(:user => users(:ernest))
    end
  end   
  
  def test_material_rating_for_quest
    assert_valid new_rating(:user => users(:visitor1))
  end
  
  def test_rate_as_guest
    assert_difference(MaterialConvincingRating, :count) do
      create_rating(:user => users(:visitor1))
    end
  end  
  
  
  def create_rating(changes={})
    r = new_rating(changes)
    r.save
    r
  end
  
  def new_rating(changes={})
    MaterialConvincingRating.new({:user => users(:grace), :subject => support_materials(:google), :value => 1}.merge(changes))    
  end
end
