require File.dirname(__FILE__) + '/../test_helper'

class MaskFilterItemTest < Test::Rails::TestCase
  
  def test_simple_glob_2_SQL_like_escapes
    assert_equal_SQL_from_glob "lee\_d@omara.ca",  'lee_d@omara.ca'
    assert_equal_SQL_from_glob "\%@omara.ca",  '%@omara.ca'
  end

  def test_simple_glob_2_SQL_like_asterisk
    assert_equal_SQL_from_glob "%",  "*"
  end
  
  def test_matches
    create_fixtures :registration_filter_items
    assert MaskFilterItem.match?('bob@parl.gc.ca') # '*@*.gc.ca'
  end
  
  def test_matches_fail
    create_fixtures :registration_filter_items
    assert !MaskFilterItem.match?('frank@us.gov') # '*@*.gc.ca'
  end
  
  def test_value_setter
    m = MaskFilterItem.new
    m.value = "*"
    assert_equal "%", m.send(:read_attribute, :value)
  end
  
  def test_value_setter_at_new
    m = MaskFilterItem.new(:value => "*")
    assert_equal "%", m.send(:read_attribute, :value)
  end
  
  def test_value_reader
    m = MaskFilterItem.new
    m.send(:write_attribute, :value, '%@bob.ca')
    assert_equal "*@bob.ca", m.value
  end
  
  def test_matching_users
    create_fixtures :users
    assert_equal 4, MaskFilterItem.new(:value => '*@example.com').matching_users.length
    assert_equal 0, MaskFilterItem.new(:value => '*@nowhere.net').matching_users.length
  end

  def test_find_for_user
    create_fixtures :registration_filter_items
    assert_equal 1, MaskFilterItem.find_for_user(User.new(:email => 'karl@parl.gc.ca')).length
  end
  
 private
  
  def assert_equal_SQL_from_glob(regexp_str, glob_str)
    assert_equal regexp_str, MaskFilterItem.new.glob2sql(glob_str)
  end
end
