require File.dirname(__FILE__) + '/../test_helper'

class GuestTest < Test::Rails::TestCase
  fixtures :comments, :users, :topics, :ratings, :ratings
  
  def test_destroy_unused_accounts
    Guest.create # no reads or ratings
    assert_difference(Guest, :count, "remove new, unused Guest account", -1) do
      Guest.destroy_unused_accounts
    end
  end
  
  def test_destroy_unused_accounts_should_leave_accounts_with_readings
    g = Guest.create
    g.record_read_of(comments(:first_reply))
    assert_no_difference(Guest, :count) { Guest.destroy_unused_accounts }
  end
  
  def test_destroy_unused_accounts_should_leave_accounts_with_rating
    g = Guest.create
    r = comments(:first_reply).ratings.for_user(g)
    r.value = 1
    assert r.save
    assert_no_difference(Guest, :count) { Guest.destroy_unused_accounts }
  end
end
