require "#{File.dirname(__FILE__)}/../test_helper"

class SuspendedUserTest < ActionController::IntegrationTest
  fixtures :users, :topics, :comments, :settings
  
  def setup
    ApplicationPolicy.stubs(:guests_allowed?).returns(true)
  end
  
  def test_suspended_users_who_are_logged_in_get_logged_out
    quentin = users(:quentin)
    assert !quentin.suspended?
    
    post login_url, {:email => quentin.email, :password => quentin.password}
    assert session[:user]
    assert User.find(session[:user]).is_a?(Participant)
    
    # quentin gets the boot
    quentin.toggle!(:suspended)
    
    get '/library'
    assert_response :redirect
    assert_redirected_to logout_url
  end  
  
end