require File.dirname(__FILE__) + '/../test_helper'

class SearchControllerTest < Test::Rails::ControllerTestCase
  
  def setup
    super
    ApplicationPolicy.stubs(:guests_allowed?).returns(true)
    ApplicationPolicy.stubs(:participation_enabled?).returns(true)    
  end
    
  def test_index
    Comment.search_args    = ['radish']
    Comment.search_results = [stub(:total => 0, :records => [])]
    Topic.search_args      = [[]]
    Topic.search_results   = [stub(:total => 0, :records => [])]
    
    get :index, :terms => 'radish'
    assert_response :success 
    assert_assigned :comments
    assert_assigned :topics
  end  
  
  def test_index_no_terms
    Comment.search_args    = [[]]
    Comment.search_results = [stub(:total => 0, :records => [])]
    Topic.search_args      = [[]]
    Topic.search_results   = [stub(:total => 0, :records => [])]
    
    get :index
    assert_response :success 
    assert !assigns(:comments)
    assert !assigns(:topics)
  end  
  
  def test_index_no_terms_sets_flash
    Comment.search_args    = [[]]
    Comment.search_results = [stub(:total => 0, :records => [])]
    Topic.search_args      = [[]]
    Topic.search_results   = [stub(:total => 0, :records => [])]
    
    get :index
    assert_response :success 
    assert_flash(:notice, 'please enter a search term')
  end  
  
  def test_index_searches_comments_and_topics
    Comment.search_args = ['Red', 'Wimbley']
    Comment.search_results = [Comment.find(1)]
    Topic.search_args      = [[]]
    Topic.search_results   = [stub(:total => 0, :records => [])]

    Comment.expects(:search).with('Red Wimbley', {}).returns(stub(:total => 0, :records => []))
    Topic.expects(:search).returns(stub(:total => 0, :records => []))
    get :index, :terms => 'Red Wimbley'
    assert_assigned :comments
    assert_assigned :topics
  end  
  
  
end

class SearchControllerScopeTest < Test::Rails::ControllerTestCase
  fixtures :users, :access_passes, :topics, :search_terms, :search_terms_topics, :comments_search_terms
  
  def setup
    @controller_class_name = "SearchController" # help ZenTest find the controller
    super
    ApplicationPolicy.stubs(:guests_allowed?).returns(true)
    ApplicationPolicy.stubs(:participation_enabled?).returns(true)
  end
  
  def test_search_limited_for_participant    
    Comment.search_args    = [[]]
    Comment.search_results = [stub(:total => 0, :records => [])]
    Topic.search_args      = [[]]
    Topic.search_results   = [stub(:total => 0, :records => [Topic.find(:first)])]

    session[:user] = 6 # ernest, participant
    Topic.expects(:search).with('intopic1and3', {:conditions => ["approved = 1 && `start_date` <= ? && (private != 1 || topics.id in (?))", Date.today, [1,2]]}).returns(stub(:total => 0, :records => []))
    get :index, :terms => 'intopic1and3'

    assert_assigned :comments
    assert_assigned :topics
  end

  def test_search_limited_for_expert_no_on_access_list
    Comment.search_args    = [[]]
    Comment.search_results = [stub(:total => 0, :records => [])]
    session[:user] = 3 # frank, expert
    Topic.expects(:search).with('intopic1and3', {:conditions => ["(private != 1 || topics.id in (?))", []]}).returns(stub(:total => 0, :records => []))
    
    get :index, :terms => 'intopic1and3'
    
    assert_assigned :comments
    assert_assigned :topics
  end
  
  def test_search_not_limited_for_admin
    Comment.search_args    = [[]]
    Comment.search_results = [stub(:total => 0, :records => [])]
    Topic.expects(:search).with('intopic1and3', {}).returns(stub(:total => 0, :records => []))
    session[:user] = 4 # launra, admin
    get :index, :terms => 'intopic1and3'
  
    assert_assigned :comments
    assert_assigned :topics
  end
  
end