require File.dirname(__FILE__) + '/../test_helper'

class MetricsControllerTest < Test::Rails::ControllerTestCase
  fixtures :comments, :users, :topics, :ratings, :readings 
  
  def setup
    super
    @request.session[:user] = users(:laura).id # laura is an admin
  end

  def test_no_comments
    Comment.destroy_all
    assert_nothing_raised { get :index }
  end
  
  def test_no_topics
    Topic.destroy_all
    assert_nothing_raised { get :index }
  end
  
  def test_no_ratings
    AbstractRating.delete_all
    assert_nothing_raised { get :index }
  end
  
  def test_no_reading
    Reading.delete_all
    assert_nothing_raised { get :index }
  end
  
  def test_ratings_logic
    get :index
    assert_assigned :topic_highest_rated, topics(:direct_democracy)
  end
  
  def test_show_sets_instance_vars
    get :show, {:id => 1}
    assert_response :success
    assert_assigned :topic

    assert_assigned :comment_most_rated         
    assert_assigned :comment_highest_rated      
    assert_assigned :comment_most_direct_replies
    assert_assigned :comment_most_read          
  end
  
  @@export_types = %w{topic support_material participant user comment 
    topic_rating comment_rating support_material_informative_rating support_material_convincing_rating
    comment_reading support_material_reading topic_reading}
  
  # poor approximation of test matrix
  @@export_types.each do |model|
    [
      ['normal',       lambda {}],
      ['no_ratings',   lambda {AbstractRating.delete_all}],
      ['no_topics',    lambda {Topic.delete_all}],
      ['no_comments',  lambda {Comment.delete_all}],
      ['no_readings',  lambda {Reading.delete_all}],
    ].each do | situation, setup_action|
      define_method("test_export_html_no_topic_scope_not_exlosive_#{model}_when_#{situation}") do
        setup_action.call
        assert_nothing_raised { get 'export_html', :model => model }
      end
      next if model =='topic' || situation == 'no_topics'
      define_method("test_export_html_topic_scope_not_exlosive_#{model}_when_#{situation}") do
        setup_action.call
        assert_nothing_raised { get 'export_html', :topic_id => 1, :model => model }
      end
    end
  end
  
end
