require File.dirname(__FILE__) + '/../test_helper'

class FeedsControllerTest < Test::Rails::ControllerTestCase

  fixtures :topics, :users, :settings, :support_materials, :readings, :comments
  
  def setup
    super
    ApplicationPolicy.stubs(:guests_allowed?).returns(true)
  end
  
  def test_rss
    login_as :visitor1
    get :rss
    assert assigns(:topics)
    assert_equal 1, assigns(:topics).length
  end
  
  def test_rss_should_not_create_session
    session[:user] = nil
    get :rss
    assert !session[:user], "User found in session #{session[:user]}"
  end
  
end