require File.dirname(__FILE__) + '/../test_helper'

class BlogControllerTest < Test::Rails::ControllerTestCase

  fixtures :topics, :users, :settings, :support_materials, :readings, :ratings
  
  def setup
    super
    ApplicationPolicy.stubs(:guests_allowed?).returns(true)
  end
  
  def test_index
    get :index
    assert_response :success # Assert we got a 200
    assert_assigned :topics
    assert_assigned :most_read_comments     
    assert_assigned :highest_rated_comments 
    assert_assigned :newest_comments 
    assert_assigned :blog_font_page_greeting
    assert_assigned :ten_best_rated_participants
  end  
  
end
