# This file is autogenerated. Instead of editing this file, please use the
# migrations feature of ActiveRecord to incrementally modify your database, and
# then regenerate this schema definition.

ActiveRecord::Schema.define(:version => 53) do

  create_table "access_passes", :force => true do |t|
    t.column "user_id",                     :integer
    t.column "topic_id",                    :integer
    t.column "registration_filter_item_id", :integer
  end

  create_table "avatars", :force => true do |t|
    t.column "parent_id",    :integer
    t.column "user_id",      :integer
    t.column "content_type", :string
    t.column "filename",     :string
    t.column "thumbnail",    :string
    t.column "size",         :integer
    t.column "width",        :integer
    t.column "height",       :integer
  end

  create_table "comments", :force => true do |t|
    t.column "body",          :text
    t.column "created_by",    :integer
    t.column "created_at",    :datetime
    t.column "topic_id",      :integer,  :default => 0
    t.column "root_id",       :integer,  :default => 0
    t.column "parent_id",     :integer,  :default => 0
    t.column "lft",           :integer,  :default => 0
    t.column "rgt",           :integer,  :default => 0
    t.column "depth",         :integer,  :default => 0
    t.column "removed",       :boolean,  :default => false
    t.column "word_count",    :integer
    t.column "reading_count", :integer,  :default => 0
    t.column "avg_rating",    :float
  end

  add_index "comments", ["root_id"], :name => "root_id"
  add_index "comments", ["created_by"], :name => "index_comments_on_created_by"
  add_index "comments", ["topic_id"], :name => "index_comments_on_topic_id"
  add_index "comments", ["created_at"], :name => "index_comments_on_created_at"

  create_table "logged_exceptions", :force => true do |t|
    t.column "exception_class", :string
    t.column "controller_name", :string
    t.column "action_name",     :string
    t.column "message",         :string
    t.column "backtrace",       :text
    t.column "environment",     :text
    t.column "request",         :text
    t.column "created_at",      :datetime
  end

  create_table "page_versions", :force => true do |t|
    t.column "page_id",     :integer
    t.column "version",     :integer
    t.column "parent_id",   :integer
    t.column "full_path",   :text
    t.column "title",       :string
    t.column "slug",        :string
    t.column "keywords",    :string
    t.column "body",        :text
    t.column "filter_type", :string,   :limit => 25, :default => "Textile"
    t.column "author",      :string
    t.column "position",    :integer,                :default => 0
    t.column "updated_on",  :datetime
    t.column "created_on",  :datetime
  end

  create_table "ratings", :force => true do |t|
    t.column "value",          :integer,  :default => 0, :null => false
    t.column "subject_id",     :integer,  :default => 0, :null => false
    t.column "participant_id", :integer
    t.column "created_on",     :datetime,                :null => false
    t.column "type",           :string
  end

  add_index "ratings", ["subject_id"], :name => "subject_id"
  add_index "ratings", ["value"], :name => "value"
  add_index "ratings", ["participant_id"], :name => "index_ratings_on_participant_id"
  add_index "ratings", ["created_on"], :name => "index_ratings_on_created_on"

  create_table "readings", :force => true do |t|
    t.column "participant_id", :integer,  :default => 0, :null => false
    t.column "readable_id",    :integer
    t.column "created_at",     :datetime
    t.column "readable_type",  :string
  end

  add_index "readings", ["participant_id"], :name => "index_readings_on_participant_id"
  add_index "readings", ["readable_id", "readable_type"], :name => "index_readings_on_readable"

  create_table "registration_filter_items", :force => true do |t|
    t.column "type",     :string
    t.column "value",    :string
    t.column "topic_id", :integer
  end

  create_table "sessions", :force => true do |t|
    t.column "session_id", :string
    t.column "data",       :text
    t.column "updated_at", :datetime
    t.column "created_at", :datetime
  end

  add_index "sessions", ["session_id"], :name => "sessions_session_id_index"

  create_table "settings", :force => true do |t|
    t.column "var",        :string,   :default => "", :null => false
    t.column "value",      :string
    t.column "created_at", :datetime
    t.column "updated_at", :datetime
  end

  create_table "snippets", :force => true do |t|
    t.column "name", :string
    t.column "body", :text
  end

  create_table "support_materials", :force => true do |t|
    t.column "name",          :string,  :default => "", :null => false
    t.column "url",           :string,  :default => ""
    t.column "topic_id",      :integer, :default => 0,  :null => false
    t.column "reading_count", :integer
    t.column "filename",      :string
    t.column "content_type",  :string
    t.column "size",          :integer
    t.column "parent_id",     :integer
  end

  create_table "topics", :force => true do |t|
    t.column "title",            :string
    t.column "introduction",     :text
    t.column "body_copy",        :text
    t.column "start_date",       :date
    t.column "expert_id",        :integer
    t.column "approved",         :binary
    t.column "lock_version",     :integer, :default => 0
    t.column "continue_reading", :string,  :default => "Read the full piece"
    t.column "private",          :boolean
    t.column "reading_count",    :integer
  end

  create_table "users", :force => true do |t|
    t.column "name",                               :string
    t.column "type",                               :string
    t.column "email",                              :string,   :limit => 100
    t.column "crypted_password",                   :string,   :limit => 40
    t.column "salt",                               :string,   :limit => 40
    t.column "created_at",                         :datetime
    t.column "bio",                                :text
    t.column "picture",                            :string
    t.column "user_number",                        :string
    t.column "year_of_birth",                      :integer
    t.column "gender",                             :integer,                 :default => 0
    t.column "postal_code",                        :string
    t.column "login_key",                          :string
    t.column "verified",                           :boolean,                 :default => false
    t.column "login_key_expires_at",               :datetime
    t.column "avg_rating",                         :float
    t.column "suspended",                          :boolean,                 :default => false
    t.column "receive_messages_from_participants", :boolean,                 :default => true
  end

  add_index "users", ["type"], :name => "index_users_on_type"

end
