class IndexSearchTables < ActiveRecord::Migration
    def self.up
      add_index :search_terms, :term
      
      add_index :search_terms_topics, :topic_id
      add_index :search_terms_topics, :search_term_id
      
      add_index :comments_search_terms, :comment_id
      add_index :comments_search_terms, :search_term_id
    end

    def self.down
      remove_index :search_terms, :term
      
      remove_index :search_terms_topics, :search_term_id
      remove_index :search_terms_topics, :topic_id
      
      remove_index :comments_search_terms, :comment_id
      remove_index :comments_search_terms, :search_term_id
    end

end
