# This module is designed to act as an association extension. 
#
# It is used by SupportMaterial and Topic on their different Rating associtions. It is not used by Comment.
module RatingForUserAssociationExtension
  # For participants, return their existing rating for this subject(if rated), otherwise
  # return a new(unset) rating object.
  #
  # Returns nil for non-participants.
  def for_user(user)
    # don't do anything for non-participants
    return nil unless RatingSpecification::user_is_a_participant_or_guest(proxy_owner, user)
    # grab the existing rating, or build a new one
    detect{|r|r.participant_id == user.id } || build(:user => user) 
    #  Could do this the other way: compare against list of what this user has rated
  end
  
  # Calculate the average value, not counting the troublesome value 77, which is used for 'unsure'
  def average_value_excluding_77s
    average(:value, :conditions => 'value != 77')
  end
end
