# simple class to help keep our logic from spilling into the views/helpers
class MetricsGrid
  attr :values
    
  def initialize(&block)
    @values      = {}
    @bests       = {}
    yield(self)
  end
  
  def field(name, query_results)
    query_results.each do |row| 
      @values[row[0].id] ||= {}
      @values[row[0].id][name] = row[1] 
    end
    @bests[name] = query_results.inject(0) { |best, row | best >= row[1] ? best : row[1]}
  end
  
  def for_topic(topic)
    @values[topic.id]
  end
  
  # does the given value match the best on record? Ignore nil
  def is_best?(attribute_name, value)
    value && @bests[attribute_name] == value
  end  
end
