# Schema as of Fri Jun 29 21:58:21 EDT 2007 (schema version 45)
#
#  id                  :integer(11)   not null
#  value               :integer(11)   default(0), not null
#  subject_id          :integer(11)   default(0), not null
#  participant_id      :integer(11)   
#  created_on          :datetime      not null
#  type                :string(255)   
#

class CommentRating < AbstractRating
  belongs_to :subject, :class_name => 'Comment', :foreign_key => 'subject_id'
  # TODO validates value between 1-5
  validates_uniqueness_of :subject_id, :scope => [:participant_id]
  validate :not_your_own_comment

  def not_your_own_comment
    errors.add('subject', "cannot be your own comment") if comment.user == user
  end
  
  def mapping # Agree (4), Somewhat Agree (3), Unsure (77) Somewhat Disagree (2) Disagree (1)
    # TODO these strings should be stored as application settings
    [ 
      [4,  'Agree'],
      [3,  'Somewhat Agree'], 
      [77, 'Unsure'],
      [2,  'Somewhat Disagree'],
      [1,  'Disagree']
    ]
  end
  
  # so the language makes more sense
  def comment
    subject
  end

  class << self
    def report(topic_id=nil)
      if topic_id
        topic_condition = "AND comments.topic_id = #{topic_id}"
        report_raw("SELECT #{selected_fields} FROM ratings INNER JOIN comments ON ratings.subject_id = comments.id WHERE #{type_restriction} #{topic_condition} ORDER BY created_on")        
      else
        report_raw("SELECT #{selected_fields} FROM ratings WHERE #{type_restriction} ORDER BY created_on")
      end
    end    
  end

    
end
