module RaterHelper
  
  # returns a paragraph containg the content of the given block plus a rating widget all wrapped in a form
  def rate_topic_form_and_paragraph(rating, paragraph_attributes={}, &block)
    content = block ? block.call : ''
    content << (" " + rating_widget(rating)) if rating
    content_wrapped_in_a_paragraph = content_tag(:p, content, paragraph_attributes)
    if rating && rating.new_record?
      form_remote_tag(
       :url => create_rating_url(rating),
       :html =>{:class => 'rating_form'}
      )  + 
       content_wrapped_in_a_paragraph + 
       hidden_field_tag(:subject_id, rating.subject_id) + # PREMATURE instead of subject.id to avoid hitting the db
       '</form>'
    else
      content_wrapped_in_a_paragraph
    end
  end
  
  def rate_material(rating)
    content = block ? block.call : ''
    content << (" | " + rating_widget(rating)) if rating
    content_wrapped_in_a_paragraph = content_tag(:p, content, paragraph_attributes)
    if rating && rating.new_record?
      form_remote_tag(
       :url => create_rating_url(rating),
       :html =>{:class => 'rating_form'}
      ) + 
      content_wrapped_in_a_paragraph + 
      hidden_field_tag(:subject_id, rating.subject_id) +  # PREMATURE 
      '</form>'
    else
      content_wrapped_in_a_paragraph
    end
  end
  
  # the rating widget factory
  def rating_widget(rating)
    unless rating.nil?
      case rating
      when CommentRating, TopicRating
        rating_select(rating)
      when MaterialInformativeRating, MaterialConvincingRating
        rating_select(rating, {}, true)
      else
        raise "Unknown rating type"
      end
    else
      ""
    end
  end
  
  # return the rating select tag and submit button in a span tag that is hidden
  def rating_select(rating, wrapper_attributes = {}, show_question = false)
    if rating.new_record?
      content_tag( :span, 
        (show_question ? rating_question(rating) : '') +#"Do you #{rating.range_in_words}?" +
        rating_select_tag(rating), 
        {
          :class => "select-rating %s" % rating.class.subject_class.to_s.downcase,
          :id => rate_wrapper_id(rating)
        }.merge(wrapper_attributes)
      )
    else
      content_tag(:em,
        "Rated as #{rating.in_words}",
        :class => 'current-rating'
      )
    end
  end
  
  # Returns a select tag with options populated from rating.mapping
  def rating_select_tag(rating)    
    options_collection = rating.mapping.dup.unshift([0, rate_select_intro(rating)])
    content_tag(:select,
      options_from_collection_for_select(options_collection, 'first', 'last', 0),
      {:name => 'value', :onchange => 'this.form.onsubmit();'}
    )
  end
  
  def rate_select_intro(rating)
    return rating.select_intro
    #return '...' if rating.subject.is_a?(SupportMaterial)
    #' Rate as... '
  end
    
  # returns a list of rating choices using the text options returned by rating.mapping
  def rating_verbose(rating)
    if rating.new_record?
      str = content_tag(:fieldset,
        content_tag(:legend, rating_question(rating) ) +
        rating.mapping.collect do |rate_value, rate_term|
           "<a href='#{create_rating_url(rating, :value => rate_value)}' title='Rate this a #{rate_term}' >#{rate_term}</a>"
        end.join(" \n")
      )
      return str
    else
      "<p class='verbose-rating'>
        <em class='current-rating'>Rated as #{rating.in_words}.</em>
      </p>"
    end
  end
  
  # returns the HTML ID of a rating box
  def rating_id(rating)
    raise "Don't call me anymore" # TODO remove this method
    "#{rating.subject.class.to_s.underscore}_#{rating.subject_id}_rating"  # PREMATURE 
  end
  
  def create_rating_url(rating, additional_url_options = {})
    # rating_create_url({:rating_type => rating.class.to_s.underscore, :subject_id => rating.subject.id}.merge(additional_url_options))
    rating_create_url({:rating_type => rating.class.to_s.underscore, :subject_id => rating.subject_id}.merge(additional_url_options))
  end
  
  def rating_question(rating)
    case rating
    when CommentRating, TopicRating
      ''
    when MaterialInformativeRating
      "Would you describe this as informative or uninformative?"
    when MaterialConvincingRating
      "Does this change or not change your opinion?"
    else
      raise "Unknown rating type"
    end  
  end
  
  def rate_wrapper_id(rating)
    "#{rating.class.to_s.underscore}_for_#{rating.subject_id}" # PREMATURE
  end
  
  def show_rating_toggle(rating)
    rating ? "show_rating_form_hide_link('#{rate_wrapper_id(rating)}')" : '' 
  end
  
end
