class SystemController < ApplicationController
  layout "admin"
  before_filter :permision_required, :set_breadcrumb
  
  def index
  end
  
  # The DialogSpace is considered closed if Settings.open is anything that equates to false
  def on_off
    if request.post? && params[:open]
      Settings.open = params[:open] == "yes" ? true : false
      flash[:alert] = "DialogSpace now opened" if Settings.open
      redirect_to :action => 'on_off'
    end
    Settings.reload
  end
  
  def settings
    return unless request.post?
    [:application_url, :admin_email, :no_reply_email, :email_subject_label].each do |setting|
      Settings.send("#{setting}=", params[setting])
    end
    flash[:notice] = "Settings saved"
    redirect_to :action => 'index'
  end

  private
  
  # Does the current action require any specific permission?
  def action_requires_permission?
    true
  end
end
