class SnippetsController < ApplicationController
  layout :admin_or_application_layout

  before_filter :permision_required, :set_breadcrumb
  
  def index
    @snippets = Snippet.find(:all, :conditions => 'name != "privacy"')
  end
  
  def show_by_name
    @snippet = Snippet.find_by_name(params[:name])
    raise ActiveRecord::RecordNotFound unless @snippet
    set_default_breadcrumb
    @breadcrumb_trail << @snippet.name.titleize
  end
  
  def edit
    @snippet = Snippet.find(params[:id])
    @snippet.attributes = params[:snippet]
    
    if request.post? && @snippet.save
      flash[:notice] = "Snippet updated"
    end
  end
  
  def preview
    @snippet = Snippet.find(params[:id])
    @snippet.attributes = params[:snippet]
    render :inline => "<%= smarty_markdown @snippet.body %>"
  end
  
  private
  
  def action_requires_permission?
    action_name != 'show_by_name'
  end
end
