;
; Plots coverage of Mann et al. reconstructions
;
np=1082
rawdat=fltarr(5,np)
openr,1,'gridpoints.loc'
readf,1,rawdat
close,1
;
xp=reform(rawdat[2,*])
xp=standard_lon(xp,/nosort)
yp=reform(rawdat[3,*])
g=def_grid(/ipcc)
;
fd=fltarr(g.nx,g.ny)+!values.f_nan
;
for ip = 0 , np-1 do begin
  ix=where(g.x eq xp[ip],ngot)
  if ngot ne 1 then message,'wrong x'
  iy=where(g.y eq yp[ip],ngot)
  if ngot ne 1 then message,'wrong y'
  fd[ix[0],iy[0]]=1.
endfor
;
map=def_map()
map.limit=[-90,-180,90,180]
map.origx=0.
;
inter_boxfd,fd,g.x,g.y,map=map,$
  levels=[0,2],c_colors=[!p.color]
;
ml=where(finite(fd) eq 0,nmiss)
if nmiss gt 0 then fd[ml]=0
;
print,'Fractional global, NH and SH coverage of Mann et al. maps:'
gf=globalmean(fd,g.y,nhemi=nf,shemi=sf)
print,gf,nf,sf
;
end
