;
; Writes an ASCII file with gridded temperature data (land only) from
; Jones et al. data set, for April-Sept and Oct-Mar means, for European
; grid boxes only.
;
doreg=1     ; 0=all data, 1=greater European region only
missval=-9.99
;
; Get the land instrumental temperatures
;
print,'Reading in Jones land air temperature gridded data'
ncid=ncdf_open('/cru/u2/f055/data/obs/grid/surface/crutem2v_18512001.mon.nc')
fdmon=crunc_rddata(ncid,grid=g,info=i)
ncdf_close,ncid
;
; Compute Apr-Sep & Oct-Mar means from the data (requiring 3 or more months
; of data)
;
nmon=12
nyr=g.nt/nmon
fdmon=reform(fdmon,g.nx*g.ny,nmon,nyr)
fdseas1=mkseason(fdmon,3,8,datathresh=3)
fdseas2=mkseason(fdmon,9,2,datathresh=3)
fdseas=fltarr(g.nx,g.ny,nyr,2)
fdseas[*,*,*,0]=fdseas1[*,*,*]
fdseas[*,*,*,1]=fdseas2[*,*,*]
timey=findgen(nyr)+g.year(0)
;
map=def_map(/npolar)
;
case doreg of
  0: begin
    print,'OUTPUTTING ALL DATA'
  end
  1: begin
    print,'OUTPUTTING GREATER EUROPEAN DATA ONLY'
    for ix = 0 , g.nx-1 do begin
      for iy = 0 , g.ny-1 do begin
        x=g.x[ix]
        y=g.y[iy]
        if ( (x le -15) or (x gt 61) or (y le 35) or (y gt 75) or $
          ( (x gt 30) and (y le 60) ) ) then fdseas[ix,iy,*,*]=!values.f_nan
      endfor
    endfor
    map.limit=[20,-60,90,90]
  end
endcase
map.origx=mean(map.limit[[1,3]])
;
; Lets plot the location of the boxes with data
;
nseas=2
for iseas = 0 , nseas-1 do begin
boxlist=where(total(finite(fdseas[*,*,*,iseas]),3) gt 0,nbox)
fdmask=fltarr(g.nx,g.ny)*!values.f_nan
fdmask[boxlist]=20
pause
inter_boxfd,fdmask,g.x,g.y,map=map
;
fdcalibc=fdseas[*,*,*,iseas]
;
; Let's plot the average of all
;
pause
xxx=reform(fdcalibc,g.nx*g.ny,nyr)
plot,total(xxx,1,/nan)/float(total(finite(xxx),1))
;
; Now lets output the data to an ASCII file
;
ndec=ceil(nyr/10.)
;
seasname=['April-September','October-March']
openw,1,'instrumentaltemp_'+seasname[iseas]+'.dat'
printf,1,'These are gridded, instrumental temperature anomalies from CRUTEM2v'
printf,1,'(land-only) data set of Jones et al. (degC with respect to the'
printf,1,'1961-1990 mean).  Only boxes in the "European" study area are'
printf,1,'included.  These data are AVERAGE TEMPERATURES OVER '+seasname[iseas]
printf,1
printf,1,nbox,format='("Number of boxes:",I5)'
printf,1,missval,format='("Missing value:",F7.2)'
printf,1
for ix = 0 , g.nx-1 do begin
  for iy = 0 , g.ny-1 do begin
    if finite(fdmask[ix,iy]) then begin
      printf,1,g.x[ix],g.y[iy],format='(2F10.4,"  Longitude & Latitude")'
      ts1=reform(fdcalibc[ix,iy,*])
      ml=where(finite(ts1) eq 0,nmiss)
      if nmiss ge 1 then ts1[ml]=missval
      ;
      for idec = 0 , ndec-2 do begin    ; don't do last (incomplete) decade
        iyr=idec*10
        jyr=(iyr+9) < (nyr-1)
        printf,1,timey[[iyr,jyr]],ts1[iyr:jyr],format='(I4,":",I4,10F7.2)'
      endfor
    endif
  endfor
endfor
close,1
flush,-1
;
endfor
;
end
