;
; Plots location of MXD grid boxes with complete 1697-1976 data,
; differentiating those that were infilled.
;
doinfill=1    ; 0=don't mark infilled boxes, 1=do, 2=do, with same colour
trv=0           ; selects tree-ring-variable: 0=MXD 1=TRW
case trv of
  0: begin
    fnadd='mxd'
    end
  1: begin
    fnadd='trw'
    end
endcase
titadd=strupcase(fnadd)
;
restore,fnadd+'_infill.idlsave'
;
shyr=[beglist,1950,reverse(endlist)]
nshow=n_elements(shyr)
;
loadct,39
;multi_plot,nrow=3,ncol=5,layout='large',/landscape
multi_plot,nrow=5,ncol=3,layout='large'
if !d.name eq 'X' then begin
  window,ysize=750
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=16
endelse
def_1color,cr,cg,cb,10,color='black'
def_1color,cr,cg,cb,11,color='mlgrey'
def_1color,cr,cg,cb,12,color='mdgrey'
;
map=def_map(/npolar)  &  map.limit(0)=20.
map.xmargin=[0,0] & map.ymargin=[0,0]
labels=def_labels(/off)
coast=def_coast(/get_device) & coast.thick=[0.5,2]
coast.color=12
;
for i = 0 , nshow-1 do begin
  ;
  iyr=where(mxdyear eq shyr(i))
  fd1=reform(mxdfd(*,*,iyr))
  fd2=reform(mxdfd2(*,*,iyr))
  fd=fd1
  fd(*,*)=!values.f_nan
;  fd(where(finite(fd2)))=1.
  fd(where(finite(fd2)))=doinfill
  fd(where(finite(fd1)))=2.
  ;
  inter_boxfd,fd,g.x,g.y,levels=[0.5,1.5,2.5],c_colors=[11,10],$
    labels=labels,map=map,coast=coast
  ;
  xyouts,-55,25,string(shyr(i),format='(I4)')
  ;
endfor
;
multi_plot,nrow=4,layout='large'
pause,/force
if !d.name eq 'X' then begin
  window,ysize=750
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=18
endelse
;
y1=total(finite(mxdfd2),1)
y1=total(y1,1)
y2=total(finite(mxdfd),1)
y2=total(y2,1)
cpl_barts,mxdyear,y2,bar_color=12,$
  /xstyle,xtitle='Year',xrange=[1400,2000],$
  /ystyle,yrange=[0,120],ytitle='Number of grid boxes with '+titadd+' data',$
  title='(c)'
oplot,mxdyear,y1,psym=10,thick=3
print,total(y1),total(y2)
;
end
