;
; Plots a map showing location of the land air temperatures that are used
; in the prediction of SLP.
;
; Get the LAT EOFs, cos they'll have the incomplete boxes set to missing.
;
restore,filename='olat_modes.idlsave'
;  timey,nretain,usefilt,usecoloc,thalf,xlon,ylat,nyr,nx,ny,fillea,ev
;
fdmask=reform(ev[*,*,0])*0.+1.
;
loadct,39
def_1color,20,color='vlgrey'
def_1color,50,color='mdgrey'
multi_plot,nrow=1
if !d.name eq 'X' then begin
  window,xsize=700,ysize=700
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=16
endelse
;
map=def_map(/npolar)  &  map.limit(0)=25.
coast=def_coast(/get_device)
coast.thick=[1,2]
labels=def_labels(/off)
;
levs=[0.5,1.5]
cols=[50]
;
inter_boxfd,fdmask,xlon,ylat,$
  map=map,coast=coast,labels=labels,$
  levels=levs,c_colors=cols
;
end
