;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=3
if !d.name eq 'X' then begin
  wintim,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=14
endelse
def_1color,20,color='palepurple'
def_1color,21,color='lpurple'
def_1color,22,color='deepblue'
def_1color,23,color='mlblue'
def_1color,24,color='vlblue'
def_1color,25,color='vvlgreen'
def_1color,26,color='lsand'
def_1color,27,color='orange'
def_1color,28,color='red'
def_1color,29,color='dred'
def_1color,40,color='mlgrey'
;
GOTO, PLOT

    restore,'calibmxd5.idlsave'
    ; Gets: g,mxdyear,mxdnyr,fdcalibu,fdcalibc,mxdfd2,timey,fdseas
yrhug=mxdyear
fdhug=fdcalibu
;
    restore,'../mann/calibmxd5_abdlow.idlsave'
    ; Gets: g,mxdyear,mxdnyr,fdcalibu
PLOT:
;
xwant=12.5
ywant=62.5
;
iwant=where(g.x eq xwant)
jwant=where(g.y eq ywant)
;
hugts=reform(fdhug[iwant[0],jwant[0],*])
abdts=reform(fdcalibu[iwant[0],jwant[0],*])
;
filter_cru,5,/nan,tsin=hugts,tslow=hl
filter_cru,5,/nan,tsin=abdts,tslow=al
;
plot,mxdyear,hl,/xstyle,xrange=[1500,1995],xtitle='Year',thick=3,$
  ytitle='Temperature anomaly  (!Uo!NC wrt 1961-90)'
oplot,yrhug,al,color=28,thick=3
oplot,!x.crange,[0,0],linestyle=1
;
end
