;
; Get summer maps
;
restore,'calibmxd5.idlsave'
; Gets: g,mxdyear,mxdnyr,fdcalibu,fdcalibc,mxdfd2,timey,fdseas
;
g2=g
yr2=mxdyear
fd2=fdcalibc
;
; Get ABD-adjusted summer maps
;
restore,'../mann/calibmxd5_abdlow.idlsave'
; Gets: g,mxdyear,mxdnyr,fdcalibu
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=4,layout='large'
if !d.name eq 'X' then begin
  window,ysize=750
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=11
endelse
def_1color,20,color='palepurple'
def_1color,21,color='lpurple'
def_1color,22,color='deepblue'
def_1color,23,color='mlblue'
def_1color,24,color='vlblue'
def_1color,25,color='vvlgreen'
def_1color,26,color='lsand'
def_1color,27,color='orange'
def_1color,28,color='red'
def_1color,29,color='dred'
;
xwant=82.5
ywant=67.5
kx=where(g.x eq xwant,ngot)
if ngot ne 1 then message,'Oops!'
ky=where(g.y eq ywant,ngot)
if ngot ne 1 then message,'Oops!'
kx=kx[0]
ky=ky[0]
;
z1=reform(fdcalibc[kx,ky,*])
z2=reform(fd2[kx,ky,*])
plot,yr2,z1-z2,/xstyle,$
  xtitle='Year',title='Low-frequency signal to add'
oplot,!x.crange,[0,0],linestyle=1
;
;plot,yr2,z2,/xstyle,/ystyle,$
;  xtitle='Year',title='Black=original  Red=low-frequency adjusted'
;oplot,mxdyear,z1,color=28
;oplot,!x.crange,[0,0],linestyle=1
;
filter_cru,/nan,10.,tsin=z1,tslow=zl1
filter_cru,/nan,10.,tsin=z2,tslow=zl2
plot,yr2,zl2,/xstyle,/ystyle,$
  xtitle='Year',title='Black=original  Red=low-frequency adjusted'
oplot,mxdyear,zl1,color=28
oplot,!x.crange,[0,0],linestyle=1
;
end
