;
; Calibrates and plots regional MXD against regional temperature
;
dolow=0         ; 1=raw and low-passed, 0=just raw
;
trv=0           ; selects tree-ring-variable: 0=MXD 1=TRW
case trv of
  0: begin
    fnvar='mxd'
    end
  1: begin
    fnvar='trw'
    end
endcase
titadd=strupcase(fnvar)
;
; Define periods for calibration
;
calper=[1881,1960]        ; calibration period
verper=[1961,1994]        ; verification period
thalf=10.
donh=1                    ; 0=do NH 1=do ALL
;
if donh eq 0 then nhtit='NH' else nhtit='ALL'
;
; Get the hemispheric series
;
restore,filename='datastore/compbest_'+fnvar+'_fixed1950.idlsave'
if donh eq 0 then nhtemp=reform(comptemp(*,3)) $
             else nhtemp=reform(comptemp(*,2))
nhmxd=reform(compmxd(*,2,0))
; Get rid of pre-1871 termperatures
knh=where(timey lt 1871)
nhtemp(knh)=!values.f_nan
;
; Get the extended hemispheric series
;
restore,filename='compts_'+fnvar+'_fixed1950.idlsave'
fullnhmxd=reform(compmxd(*,2))
;
; Get the extended MXD series
;
restore,filename='regts_'+fnvar+'_fixed1950.idlsave'
; Gets: timey,bestmxd etc.
yrmxd=timey
fullmxd=bestmxd
; Combine extended hemispheric MXD with these ones
nfull=n_elements(yrmxd)
newfm=fltarr(nfull,nreg+1)*!values.f_nan
newfm(*,0:nreg-1)=fullmxd(*,*)
newfm(*,nreg)=fullnhmxd(*)
fullmxd=newfm
;
; Get regional series (temp, and truncated MXD)
;
restore,filename='regbest_'+fnvar+'_fixed1950.idlsave'
; Gets: nreg,regname,regtemp,rawtemp,timey,bestmxd etc.
;
; Identify overlap between full and truncated MXD series
;
nyr=n_elements(timey)
kcomp=where( (yrmxd ge timey(0)) and (yrmxd le timey(nyr-1)) )
;
; Add in the hemispheric series
;
regname=[regname,nhtit]
newrt=fltarr(nyr,nreg+1)*!values.f_nan
newrt(*,0:nreg-1)=regtemp(*,*)
newrt(*,nreg)=nhtemp(*)
regtemp=newrt
newrm=fltarr(nyr,nreg+1)*!values.f_nan
newrm(*,0:nreg-1)=bestmxd(*,*,1)
newrm(*,nreg)=nhmxd(*)
bestmxd=newrm
nreg=nreg+1
;
; Prepare for plotting
;
loadct,39
multi_plot,nrow=4,ncol=1+dolow,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=20
endelse
def_1color,10,color='blue'
def_1color,11,color='red'
;
range0=[-2.0,-1.5,-2.5,-2.5,-1.5,-0.5,-2.5,-2.0,-3.0,-1.5]
range1=[ 1.5, 1.5, 2.0, 1.5, 1.0, 1.0, 1.5, 1.5, 1.5, 1.0]
;
calregts=fltarr(nfull,nreg)*!values.f_nan
;
; Process each region separately
;
;for ireg = 0 , nreg-1 do begin
for ireg = 0 , 2 do begin
  print,regname(ireg)+' '+titadd
  ;
  ; Extract series
  ;
  tstemp=reform(regtemp(*,ireg))
  tsmxd=reform(bestmxd(*,ireg))
  tsfull=reform(fullmxd(*,ireg))
  ;
  ; Identify calibration and verification subsets
  ;
  calkl=where( finite(tstemp+tsmxd) and $
               (timey ge calper(0)) and (timey le calper(1)) , ncal )
  verkl=where( finite(tstemp+tsmxd) and $
               (timey ge verper(0)) and (timey le verper(1)) , nver )
  print,'Calibration period:'+string(calper,format='(2I5)')+$
    '  length:'+string(ncal,format='(I5)')
  print,'Verification period:'+string(verper,format='(2I5)')+$
    '  length:'+string(nver,format='(I5)')
  ;
  ; Calibrate the MXD
  ;
  mkcalibrate,tsmxd(calkl),tstemp(calkl),fitcoeff=fitcoeff,autocoeff=autocoeff
  print,'RAW'
  print,'     r   alpha    beta SEalpha  SEbeta    sig    rmse'
  print,fitcoeff,format='(F6.2,4F8.4,F7.2,F8.4)'
  print,' a_mxd a_tem a_resid   ess'
  print,autocoeff,format='(3F6.2,F8.1)'
  ;
  ; And low and high passed too!
  ;
  filter_cru,/nan,thalf,tsin=tsmxd,tshigh=mxdhi,tslow=mxdlo
  filter_cru,/nan,thalf,tsin=tstemp,tshigh=temphi,tslow=templo
  mkcalibrate,mxdhi(calkl),temphi(calkl),fitcoeff=hicoeff,autocoeff=autohi
  print,'HIGH-PASSED',thalf
  print,'     r   alpha    beta SEalpha  SEbeta    sig    rmse'
  print,hicoeff,format='(F6.2,4F8.4,F7.2,F8.4)'
  print,' a_mxd a_tem a_resid   ess'
  print,autohi,format='(3F6.2,F8.1)'
  mkcalibrate,mxdlo(calkl),templo(calkl),fitcoeff=locoeff,autocoeff=autolo,$
    nlag=10
  print,'LOW-PASSED',thalf
  print,'     r   alpha    beta SEalpha  SEbeta    sig    rmse'
  print,locoeff,format='(F6.2,4F8.4,F7.2,F8.4)'
  print,' a_mxd a_tem a_resid   ess'
  print,autolo,format='(3F6.2,F8.1)'
  ;
  ; Generate calibrated record and uncertainties etc.
  ; Use the extended MXD record (after checking it matches the short one!)
  ;
  xxx=tsfull(kcomp)
  yyy=tsmxd
  tse=total( (xxx-yyy)^2 , /nan )
;  print,tse
  if tse gt 2.4 then message,'Series do not match'
  calmxd=tsfull*fitcoeff(2)+fitcoeff(1)
  calregts(*,ireg)=calmxd(*)
  filter_cru,/nan,thalf,tsin=tsfull,tshigh=fullhi,tslow=fulllo
  sepmxd=(fullhi*hicoeff(2)+hicoeff(1))+(fulllo*locoeff(2)+locoeff(1))
  ;
  ; For overlap period with non-missing data, compute correlation between
  ; the temperature series and the 2-band reconstruction
  ;
  kkk=calkl+(timey(0)-yrmxd(0))
  print,'r(Two-band calibrated series,Temp)='+$
    string(correlate(tstemp(calkl),sepmxd(kkk)),format='(F6.2)')
  ;
  if (ireg mod 2) eq 1 then ytit='Temperature anomaly  (!Uo!NC wrt 1961-90)' else ytit=' '
  pause
  plot,timey,tstemp,$
    /xstyle,xrange=[1850,2000],xtitle='Year',$
    ytitle=ytit,$
    /ystyle,yrange=[range0(ireg),range1(ireg)],$
    title=titadd+' '+regname(ireg),thick=3
  oplot,yrmxd,calmxd,color=11,thick=3
  oplot,!x.crange,[0.,0.],linestyle=1
  ;
  if dolow then begin
  filter_cru,/nan,thalf,tsin=tstemp,tslow=ylow
  plot,timey,ylow,$
    /xstyle,xrange=[1850,2000],xtitle='Year',$
    ytitle='Temperature anomaly  (!Uo!NC wrt 1961-90)',$
    /ystyle,yrange=[range0(ireg),range1(ireg)],$
    title=titadd+' '+regname(ireg),thick=3
  filter_cru,/nan,thalf,tsin=calmxd,tslow=ylow
  oplot,yrmxd,ylow,thick=3,color=11
  oplot,!x.crange,[0.,0.],linestyle=1
  endif
  ;
endfor
;
end
